
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_ATP_Iterators.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/*lint --e{564} */
/*lint --e{774} */
/************* Include Files ***********************************/
#include "SST_TST.h"
#if TST_USE_ITERTOR_MODULE
/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
/************* Private function prototype **********************/
/************************ Public Functions *********************/
/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_ATP_Iterator         
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 * Test the iteration services  begin, increment and get, decrement and get, get all handles and terminate operations
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd.
 *    5.  Open the password authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Insert a new data objects 1~4 (type: simple data) by calling: SST_InsertData.
 *    8.  Generate a new AES 1~2 (type: AES_key) key by calling: SST_AESKeyGenerate.
 *    9.  Generate a new DES (type: DES_key) key by calling: SST_DESKeyGenerate.
 *    10.   Create a new iterator #1 by calling: SST_TypeIteratorBegin. With the simple data handle 
 *    11.   Get the current iteration handle by calling: SST_TypeIteratorCurrentGet. And verify its a valid handle.
 *    12.   Get the previous iteration handle by calling by calling: SST_TypeIteratorHandleIncAndGet. And verify its a valid handle.
 *    13.   Get the previous iteration handle by calling: SST_TypeIteratorHandleDecAndGet. And verify its a valid handle.
 *    14.   Create an iterator #1 again to reset  by calling: SST_TypeIteratorBegin.
 *    15.   Get all available handles by calling: SST_TypeIteratorHandlesGet and verify you get only 4 handles
 *    16.   Create a new iterator #2 by calling: SST_TypeIteratorBegin. With the AES key data handle.
 *    17.   Create a new iterator #3 by calling: SST_TypeIteratorBegin. With the DES key data handle.
 *    18.   Get all available AES key handles by calling: SST_TypeIteratorHandlesGet and verify you get only 2 handles
 *    19.   Get all available DES key handles by calling: SST_TypeIteratorHandlesGet and verify you get only 1 handles
 *    20.   Delete the iterators (one by one) by calling: SST_TypeIteratorTerminate.
 *    21.   Delete all the data objects (one by one) by calling: SST_DataDelete.
 *    22.   Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    23.   Close the transaction by calling: SST_TransactionEnd.
 *    24.   Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SST_TST_ATP_Iterator ( void )
{
     /********* TST Variables Definitions ************/    
    int                 TST_index,TST_i,TST_HandleType,TST_NumberOfHandleMatch;
    char                TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_Iterator";
    SSTSessionId_t      TST_SessionId; 
    SSTTxnId_t          TST_TransactionId;
    SSTHandle_t         TST_AuthHandle,TST_ReceivedHandle;
    SSTHandle_t         TST_DataHandle1,TST_DataHandle2,TST_DataHandle3,TST_DataHandle4;
    SSTHandle_t         TST_AES1KeyHandle,TST_AES2KeyHandle,TST_DESKeyHandle;
    SSTDataType_t       TST_SimpleData = TST_DATA_OBJECT;
    SSTDataType_t       TST_AESKeyData = TST_AESKEY_OBJECT;
    SSTDataType_t       TST_DESKeyData = TST_DESKEY_OBJECT;
    DxUint32_t          TST_TempHandlesToRead,TST_HandlesLeftToRead;
    SSTIteratorCookie_t TST_IteratorHandle1,TST_IteratorHandle2,TST_IteratorHandle3;
    int                 TST_NumOfHandlesUsed = 4;
    SSTHandle_t         TST_ReturenedHandleBuff[TST_MAX_NUMBERS_OF_HANDLES_2READ];
    SSTHandle_t         TST_AuthDefaultHandle;
    DxError_t           TST_Status;

    /********* TST Variables initialization *********/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ** SST_TST_ATP_Iterator Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************** \n \n"));

    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    
    for (TST_HandleType = TST_INTERNAL_HANDLE ; TST_HandleType < TST_HANDLES_TYPES ; TST_HandleType++)
    {
        for (TST_index =0 ; TST_index < TST_NumberOf_IteratorTests ; TST_index++) /*To run on all test vectors*/
        {
            if (TST_HandleType == TST_INTERNAL_HANDLE)
            {   
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
                TST_DataHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle3.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_DataHandle4.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_AES1KeyHandle.objId = SST_HANDLE_RANDOM_GENERATE;
                TST_AES2KeyHandle.objId = SST_HANDLE_RANDOM_GENERATE;
        TST_DESKeyHandle.objId = SST_HANDLE_RANDOM_GENERATE;
            }
            else
            {
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using external handles          \n"));
                ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
                TST_AuthHandle.objId = TST_TEST_DEFINED_HENDLE;
                TST_DataHandle1.objId = TST_TEST_DEFINED_HENDLE_1;
                TST_DataHandle2.objId = TST_TEST_DEFINED_HENDLE_2;
                TST_DataHandle3.objId = TST_TEST_DEFINED_HENDLE_3;
                TST_DataHandle4.objId = TST_TEST_DEFINED_HENDLE_4;
                TST_AES1KeyHandle.objId = TST_TEST_DEFINED_HENDLE_5;
                TST_AES2KeyHandle.objId = TST_TEST_DEFINED_HENDLE_6;
        TST_DESKeyHandle.objId = TST_TEST_DEFINED_HENDLE_7;
            }

            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n",TST_ATP_IteratorTestData[TST_index].TST_Name,"\n"));

            /* Create a session for operations */
            /*---------------------------------*/
            TST_Status = SST_SessionCreate(&TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new password authenticator */
            /*-------------------------------------*/
            TST_AuthDefaultHandle.objDigest = 0;
      TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;
            TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                        TST_SessionId,
                                                        TST_ATP_IteratorTestData[TST_index].TST_Password,
                                                        TST_ATP_IteratorTestData[TST_index].TST_PasswordSizeInBytes,
                                                        TST_ATP_IteratorTestData[TST_index].TST_MaxNumOfTrials,
                                                        TST_AuthDefaultHandle,
                                                        &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                                                  TST_MasterTestName);


      /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open the password authentication */
            /*----------------------------------*/
            TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                               TST_AuthHandle,
                                               TST_ATP_IteratorTestData[TST_index].TST_Password,
                                               TST_ATP_IteratorTestData[TST_index].TST_PasswordSizeInBytes,
                                               TST_NO_CHALLENGE,
                                               TST_Workspace,
                                               TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Open a transaction for operations */
            /*-----------------------------------*/
            TST_Status = SST_TransactionStart(&TST_TransactionId);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Insert a new Data objects 1~4 */
            /*-------------------------------*/
            /* Data1*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle1,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert1",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*Data2*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*Data3*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle3,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert3",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

            /*data4*/
            TST_Status = SST_DataInsert(TST_TransactionId,
                                       TST_SessionId, 
                                       TST_AuthHandle,       
                                       TST_ATP_IteratorTestData[TST_index].TST_Data,
                                       TST_ATP_IteratorTestData[TST_index].TST_DataSize,
                                       DX_TRUE,
                                       TST_SimpleData,                
                                       &TST_DataHandle4,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataInsert4",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Generate AES key #1 */
            /*---------------------*/
            TST_Status = SST_AESKeyGenerate(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle,                                
                                           SST_KEY_TYPE_AES_128_BIT,
                                           TST_AESKeyData,
                                           &TST_AES1KeyHandle,
                                           TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyGenerate - 1",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Generate AES key #2 */
            /*---------------------*/
            TST_Status = SST_AESKeyGenerate(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle,                                
                                           SST_KEY_TYPE_AES_256_BIT,
                                           TST_AESKeyData,
                                           &TST_AES2KeyHandle,
                                           TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyGenerate - 2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Generate DES key */
            /*------------------*/
            TST_Status = SST_DESKeyGenerate(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle,                                
                                           SST_KEY_TYPE_3DES,
                                           TST_DESKeyData,
                                           &TST_DESKeyHandle,
                                           TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyGenerate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


      /* Create a new iterator #1 with the simple data handle */
            /*------------------------------------------------------*/
            TST_Status = SST_TypeIteratorBegin(TST_SessionId,
                        TST_SimpleData,
                        &TST_IteratorHandle1,
                        TST_Workspace,
                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IteratorBegin - 1 - simple data handle",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Get the current iterator handle */
            /*---------------------------------*/          
           TST_Status = SST_TypeIteratorCurrentGet(TST_SessionId,
                          &TST_IteratorHandle1,
                          &TST_ReceivedHandle,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorCurrentGet",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

           
            /* Check if handle is correct */
            TST_Status = TESTFAIL;
            if (!(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle4)))
                TST_Status = TESTPASS;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check if handle is correct",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Use increment and get handles and verify that all handles received are correct */
            /*--------------------------------------------------------------------------------*/
            for (TST_i =0; TST_i < TST_NumOfHandlesUsed;TST_i++)
            {
                /* Get the next iterator handle */
                TST_Status = SST_TypeIteratorHandleIncAndGet(TST_SessionId,
                                                        &TST_IteratorHandle1,
                            &TST_ReceivedHandle,
                            TST_Workspace,
                            TST_WorkspaceSizeInBytes);

                /* Check if handle is correct or reached end of list */
                if (TST_Status == SST_RC_ERROR_ITER_END_OF_TYPE)
                    TST_Status = TESTPASS;
                else
                {
                    if (!(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle1))||
                        !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle2))||
                        !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle3))||
                        !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle4)))
                        TST_Status = TESTPASS;
                }

          TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Handle is correct // API succeeded",
                            TST_ATP_IteratorTestData[TST_index].TST_Name,
                            TST_MasterTestName);

            }
            /* Use Decrement and get handle and verify that handle received is correct */
            /*-------------------------------------------------------------------------*/
            /* Get the prev iterator handle */
            /*------------------------------*/
            TST_Status = SST_TypeIteratorHandleDecAndGet(TST_SessionId,
                                                    &TST_IteratorHandle1,
                          &TST_ReceivedHandle,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IteratorHandleDecAndGet",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Check if handle is correct */
            TST_Status = TESTFAIL;
            if (!(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReceivedHandle,TST_DataHandle4)))
                TST_Status = TESTPASS;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check if handle is correct",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);



             /* Create a iterator #1 again (to reset) with the simple data handle */
            /*--------------------------------------------------------------------*/
            TST_Status = SST_TypeIteratorBegin(TST_SessionId,
                                          TST_SimpleData,
                      &TST_IteratorHandle1,
                      TST_Workspace,
                      TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorBegin - 1 - simple data handle - reset",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
     

            /* Get all handles and verify all are correct and exist */
            /*------------------------------------------------------*/
            TST_TempHandlesToRead = TST_MAX_NUMBERS_OF_HANDLES_2READ;
            TST_Status = SST_TypeIteratorHandlesGet(TST_SessionId,
                                                  &TST_IteratorHandle1,
                                                  &TST_TempHandlesToRead,                                               
                                                  TST_ReturenedHandleBuff,
                          &TST_HandlesLeftToRead,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorHandlesGet - 1",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Verify all handles returned are correct */
            /*-----------------------------------------*/
            /* Verify numbers of handles returned*/
            TST_Status = TESTFAIL;
            if ((TST_TempHandlesToRead == TST_4_HANDLES)&&
                (TST_HandlesLeftToRead == TST_ZERO))
                    TST_Status = TESTPASS;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify numbers of handles returned",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);



            /* Check that all handles returned are valid */
           TST_NumberOfHandleMatch = TST_ZERO;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle1))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle1)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle2))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle2)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle3))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle3)))
                TST_NumberOfHandleMatch++;
            if (!(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_ONE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_TWO],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_THREE],TST_DataHandle4))||
                !(SST_HANDLE_COMPARE(TST_ReturenedHandleBuff[TST_HANDLE_FOUR],TST_DataHandle4)))
                TST_NumberOfHandleMatch++;

            if (TST_NumberOfHandleMatch != TST_4_HANDLES)
                TST_Status = TESTFAIL;        

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Check that all handles returned are valid",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new iterator #2 with the AESKey data handle */
            /*------------------------------------------------------*/
            TST_Status = SST_TypeIteratorBegin(TST_SessionId,
                        TST_AESKeyData,
                        &TST_IteratorHandle2,
                        TST_Workspace,
                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorBegin - 2 - AES handle",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Create a new iterator #3 with the DESKey data handle */
            /*------------------------------------------------------*/
            TST_Status = SST_TypeIteratorBegin(TST_SessionId,
                        TST_DESKeyData,
                        &TST_IteratorHandle3,
                        TST_Workspace,
                        TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorBegin - 3 - DES handle",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Get all AES key handles and verify that only two exist */
            /*--------------------------------------------------------*/
            TST_TempHandlesToRead = TST_MAX_NUMBERS_OF_HANDLES_2READ;
            TST_Status = SST_TypeIteratorHandlesGet(TST_SessionId,
                                                  &TST_IteratorHandle2,
                                                  &TST_TempHandlesToRead,                                               
                                                  TST_ReturenedHandleBuff,
                          &TST_HandlesLeftToRead,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IteratorAllHandlesGet - 2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Verify numbers of handles returned*/
            TST_Status = TESTFAIL;
            if ((TST_TempHandlesToRead == TST_2_HANDLES)&&
                (TST_HandlesLeftToRead == TST_ZERO))
                    TST_Status = TESTPASS;

         ATP_LOG_TST_PRINT((SST_TST_DBG_HIGH,"TST_TempHandlesToRead = %d\nTST_HandlesLeftToRead = %d\n"
                           "TST_IteratorHandle2.prefixMsb       =0x%x\n"
                           "TST_IteratorHandle2.prefixLsb       =0x%x\n"
                           "TST_IteratorHandle2.prefixSize      = %d\n"
                           "TST_IteratorHandle2.lastPositionMsb = 0x%x\n"
                           "TST_IteratorHandle2.lastPositionLsb = 0x%x\n",
                            TST_TempHandlesToRead,
                            TST_HandlesLeftToRead,
                            TST_IteratorHandle2.prefixMsb,
                            TST_IteratorHandle2.prefixLsb,
                            TST_IteratorHandle2.prefixSize,      
                            TST_IteratorHandle2.lastPositionMsb, 
                            TST_IteratorHandle2.lastPositionLsb));

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify numbers of handles returned",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Get all DES key handle and verify that only one exist */
            /*-------------------------------------------------------*/
            TST_TempHandlesToRead = TST_MAX_NUMBERS_OF_HANDLES_2READ;
            TST_Status = SST_TypeIteratorHandlesGet(TST_SessionId,
                                                  &TST_IteratorHandle3,
                                                  &TST_TempHandlesToRead,                                               
                                                  TST_ReturenedHandleBuff,
                          &TST_HandlesLeftToRead,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_IteratorAllHandlesGet - 3",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /* Verify all handles returned are correct */
            /*-----------------------------------------*/
            /* Verify numbers of handles returned*/
            TST_Status = TESTFAIL;
            if ((TST_TempHandlesToRead == TST_1_HANDLES)&&
                (TST_HandlesLeftToRead == TST_ZERO))
                    TST_Status = TESTPASS;

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Verify numbers of handles returned",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
    

            /* Delete Iterators */
            /*------------------*/
            /*Delete iterator#1*/
            TST_Status = SST_TypeIteratorTerminate(TST_SessionId, 
                          &TST_IteratorHandle1,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorTerminate",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  


            /*Delete iterator#2*/
            TST_Status = SST_TypeIteratorTerminate(TST_SessionId, 
                          &TST_IteratorHandle2,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TypeIteratorTerminate2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /*Delete iterator#1*/
            TST_Status = SST_TypeIteratorTerminate(TST_SessionId, 
                          &TST_IteratorHandle3,
                          TST_Workspace,
                          TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_TypeIteratorTerminate3",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
    


            /* Delete all data objects */
            /*-------------------------*/
            /*DataObject#1*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle1,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_DataDelete - #1",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DataObject#2*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle2,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_DataDelete - #2",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DataObject#3*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle3,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_DataDelete - #3",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
  

            /*DataObject#4*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DataHandle4,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_DataDelete - #4",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*AESKeyObject#1*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_AES1KeyHandle,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_DataDelete - TST_AES1Key",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*AESKeyObject#2*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_AES2KeyHandle,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_DataDelete - TST_AES2Key",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /*DESKeyObject*/
            TST_Status = SST_DataDelete(TST_TransactionId,
                                        TST_SessionId,  
                                        TST_DESKeyHandle,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);

            TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_DataDelete - TST_DESKey",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Delete the authenticator */
            /*--------------------------*/
            TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                                TST_AuthHandle);

      TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_AuthenticatorDelete - Master authenticator",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);


            /* Close the transaction */
            /*-----------------------*/
            TST_Status = SST_TransactionEnd(TST_TransactionId,
                       DX_TRUE,/*reflash sensitive*/
                       TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_TransactionEnd",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);
    

            /* Delete the session */
            /*--------------------*/
            TST_Status = SST_SessionDelete(TST_SessionId);

      TST_ATP_CHECK_ERROR_RETURN (TST_Status,"SST_SessionDelete",
                          TST_ATP_IteratorTestData[TST_index].TST_Name,
                          TST_MasterTestName);

           


        }/*End of TST_index "for loop" */
    }/*End of TST_HandleType "for loop" */
    return TST_Status;

  EXIT_ON_ERROR:
  {
    return DX_FAILURE;
  }
}/* End of SST_TST_ATP_BasicDataOp */



/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/

#endif

